/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.util.Base64;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static final String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to byte, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new JSONException("can not cast to short, value : " + value);
    }

    public static final BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static final BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static final Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new JSONException("can not cast to float, value : " + value);
    }

    public static final Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        throw new JSONException("can not cast to double, value : " + value);
    }

    public static final java.util.Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new java.util.Date(longValue);
    }

    public static final Date castToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static final Timestamp castToTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Timestamp(longValue);
    }

    public static final Long castToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Long.parseLong(strVal);
        }
        throw new JSONException("can not cast to long, value : " + value);
    }

    public static final Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Integer.parseInt(strVal);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return Base64.decodeFast((String)value);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0) {
                return null;
            }
            if ("true".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equals(str)) {
                return Boolean.FALSE;
            }
            if ("1".equals(str)) {
                return Boolean.TRUE;
            }
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return TypeUtils.cast(obj, clazz, ParserConfig.getGlobalInstance());
    }

    public static final <T> T cast(Object obj, Class<T> clazz, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            return TypeUtils.castToJavaBean((Map)obj, clazz, mapping);
        }
        if (clazz.isArray() && obj instanceof Collection) {
            Collection collection = (Collection)obj;
            int index = 0;
            Object array = Array.newInstance(clazz.getComponentType(), collection.size());
            for (Object item : collection) {
                Object value = TypeUtils.cast(item, clazz.getComponentType(), mapping);
                Array.set(array, index, value);
                ++index;
            }
            return (T)array;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(obj);
        }
        if (clazz == java.util.Date.class) {
            return (T)TypeUtils.castToDate(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToSqlDate(obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(obj, clazz, mapping);
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T castToEnum(Object obj, Class<T> clazz, ParserConfig mapping) {
        try {
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() == 0) {
                    return null;
                }
                return Enum.valueOf(clazz, name);
            }
            if (obj instanceof Number) {
                Object[] values;
                int ordinal = ((Number)obj).intValue();
                Method method = clazz.getMethod("values", new Class[0]);
                for (Object value : values = (Object[])method.invoke(null, new Object[0])) {
                    Enum e = (Enum)value;
                    if (e.ordinal() != ordinal) continue;
                    return (T)e;
                }
            }
        }
        catch (Exception ex) {
            throw new JSONException("can not cast to : " + clazz.getName(), ex);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type rawTye = type.getRawType();
        if (rawTye == List.class || rawTye == ArrayList.class) {
            Type itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                ArrayList<T> list = new ArrayList<T>();
                for (Object item : (Iterable)obj) {
                    list.add(TypeUtils.cast(item, itemType, mapping));
                }
                return (T)list;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig mapping) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : value.intValue();
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get("@type");
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                clazz = TypeUtils.loadClass(className);
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            }
            Map<String, FieldDeserializer> setters = mapping.getFieldDeserializers(clazz);
            Object object = clazz.newInstance();
            for (Map.Entry<String, FieldDeserializer> entry : setters.entrySet()) {
                String key = entry.getKey();
                Method method = entry.getValue().getMethod();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                value = TypeUtils.cast(value, method.getGenericParameterTypes()[0], mapping);
                method.invoke(object, value);
            }
            return (T)object;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public static Class<?> loadClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return clazz;
        }
        catch (Throwable e) {
            try {
                clazz = Class.forName(className);
                return clazz;
            }
            catch (Throwable throwable) {
                return clazz;
            }
        }
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        LinkedHashMap<String, FieldInfo> fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            Field field;
            String propertyName;
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, null));
                    continue;
                }
            }
            if (methodName.startsWith("get")) {
                if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) continue;
                propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                field = ParserConfig.getField(clazz, propertyName);
                if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, field));
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            field = ParserConfig.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, field));
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Modifier.isPublic(((Field)accessibleObject).getModifiers()) || fieldInfoMap.containsKey(((Field)accessibleObject).getName())) continue;
            fieldInfoMap.put(((Field)accessibleObject).getName(), new FieldInfo(((Field)accessibleObject).getName(), null, (Field)accessibleObject));
        }
        for (FieldInfo fieldInfo : fieldInfoMap.values()) {
            fieldInfoList.add(fieldInfo);
        }
        return fieldInfoList;
    }
}

