/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        if (lexer.token() == 16) {
            String key = lexer.scanSymbol(parser.getSymbolTable());
            if ("val" != key) {
                throw new JSONException("syntax error");
            }
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
                throw new JSONException("syntax error");
            }
            long val = lexer.longValue();
            lexer.nextToken(13);
            if (lexer.token() != 13) {
                throw new JSONException("syntax error");
            }
            lexer.nextToken(16);
            return (T)new java.sql.Date(val);
        }
        Object val = parser.parse();
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            val = new java.sql.Date(((Date)val).getTime());
        } else if (val instanceof Number) {
            val = new java.sql.Date(((Number)val).longValue());
        } else {
            if (val instanceof String) {
                String strVal = (String)val;
                if (strVal.length() == 0) {
                    return null;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(JSON.DEFFAULT_DATE_FORMAT);
                try {
                    Date date = dateFormat.parse(strVal);
                    return (T)new java.sql.Date(date.getTime());
                }
                catch (ParseException e) {
                    long longVal = Long.parseLong(strVal);
                    return (T)new java.sql.Date(longVal);
                }
            }
            throw new JSONException("parse error : " + val);
        }
        return (T)val;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

