/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListTypeFieldDeserializer
extends FieldDeserializer {
    private final Type itemType;
    private int itemFastMatchToken;
    private ObjectDeserializer deserializer;

    public ArrayListTypeFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        Type fieldType = this.getFieldType();
        this.itemType = fieldType instanceof ParameterizedType ? ((ParameterizedType)this.getFieldType()).getActualTypeArguments()[0] : Object.class;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Map<String, Object> fieldValues) {
        if (parser.getLexer().token() == 8) {
            this.setValue(object, null);
            return;
        }
        ArrayList list = new ArrayList();
        ParseContext context = parser.getContext();
        parser.setContext(context, object, this.fieldInfo.getName());
        this.parseArray(parser, list);
        parser.setContext(context);
        if (object == null) {
            fieldValues.put(this.fieldInfo.getName(), list);
        } else {
            this.setValue(object, list);
        }
    }

    public final void parseArray(DefaultJSONParser parser, Collection array) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + JSONToken.name(lexer.token()));
        }
        if (this.deserializer == null) {
            this.deserializer = parser.getConfig().getDeserializer(this.itemType);
            this.itemFastMatchToken = this.deserializer.getFastMatchToken();
        }
        lexer.nextToken(this.itemFastMatchToken);
        int i = 0;
        while (true) {
            if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                while (lexer.token() == 16) {
                    lexer.nextToken();
                }
            }
            if (lexer.token() == 15) break;
            Object val = this.deserializer.deserialze(parser, this.itemType, i);
            array.add(val);
            parser.checkListResolve(array);
            if (lexer.token() == 16) {
                lexer.nextToken(this.itemFastMatchToken);
            }
            ++i;
        }
        lexer.nextToken(16);
    }
}

