/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListStringDeserializer
implements ObjectDeserializer {
    public static final ArrayListStringDeserializer instance = new ArrayListStringDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Type rawType;
        AbstractCollection array = null;
        if (type == Set.class || type == HashSet.class) {
            array = new HashSet();
        } else if (type instanceof ParameterizedType && ((rawType = ((ParameterizedType)type).getRawType()) == Set.class || rawType == HashSet.class)) {
            array = new HashSet();
        }
        if (array == null) {
            array = new ArrayList();
        }
        ArrayListStringDeserializer.parseArray(parser, array);
        return (T)array;
    }

    public static void parseArray(DefaultJSONParser parser, Collection array) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return;
        }
        if (lexer.token() == 21) {
            lexer.nextToken();
        }
        if (lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + lexer.token());
        }
        lexer.nextToken(4);
        while (true) {
            String value;
            if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                while (lexer.token() == 16) {
                    lexer.nextToken();
                }
            }
            if (lexer.token() == 15) break;
            if (lexer.token() == 4) {
                value = lexer.stringVal();
                lexer.nextToken(16);
            } else {
                Object obj = parser.parse();
                value = obj == null ? null : obj.toString();
            }
            array.add(value);
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        lexer.nextToken(16);
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

