/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.AbstractJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.DefaultObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.ListResolveFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJSONParser
extends AbstractJSONParser {
    protected final JSONLexer lexer;
    protected final Object input;
    protected final SymbolTable symbolTable;
    protected ParserConfig config;
    public static final int NONE = 0;
    public static final int NeedToResolve = 1;
    public static final int TypeNameRedirect = 2;
    private int resolveStatus = 0;
    private DefaultObjectDeserializer derializer = new DefaultObjectDeserializer();
    private ParseContext context;
    private ParseContext[] contextArray = new ParseContext[8];
    private int contextArrayIndex = 0;
    private final List<ResolveTask> resolveTaskList = new ArrayList<ResolveTask>();
    private static final Set<Class<?>> primitiveClasses = new HashSet();

    public Object getObject(String path) {
        for (int i = 0; i < this.contextArrayIndex; ++i) {
            if (!path.equals(this.contextArray[i].getPath())) continue;
            return this.contextArray[i].getObject();
        }
        return null;
    }

    public DefaultJSONParser(String input) {
        this(input, ParserConfig.getGlobalInstance(), JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String input, ParserConfig config) {
        this((Object)input, new JSONScanner(input, JSON.DEFAULT_PARSER_FEATURE), config);
    }

    public DefaultJSONParser(String input, ParserConfig config, int features) {
        this((Object)input, new JSONScanner(input, features), config);
    }

    public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
        this(input, new JSONScanner(input, length, features), config);
    }

    public DefaultJSONParser(Object input, JSONLexer lexer, ParserConfig config) {
        this.input = input;
        this.lexer = lexer;
        this.config = config;
        this.symbolTable = config.getSymbolTable();
        lexer.nextToken(12);
    }

    public int getResolveStatus() {
        return this.resolveStatus;
    }

    public void setResolveStatus(int resolveStatus) {
        this.resolveStatus = resolveStatus;
    }

    public void checkListResolve(Collection array) {
        if (this.resolveStatus == 1) {
            int index = array.size() - 1;
            List list = (List)array;
            ResolveTask task = this.getLastResolveTask();
            task.setFieldDeserializer(new ListResolveFieldDeserializer(list, index));
            task.setOwnerContext(this.context);
            this.setResolveStatus(0);
        }
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public JSONLexer getLexer() {
        return this.lexer;
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    @Override
    public final Object parseObject(Map object, Object fieldName) {
        JSONScanner lexer = (JSONScanner)this.lexer;
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ParseContext context = this.getContext();
        try {
            Map map;
            Object key;
            char ch;
            while (true) {
                Object value;
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (ch == ',') {
                        lexer.incrementBufferPosition();
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                    }
                }
                if (ch == '\"') {
                    key = lexer.scanSymbol(this.symbolTable, '\"');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                    }
                } else {
                    if (ch == '}') {
                        lexer.incrementBufferPosition();
                        lexer.resetStringPosition();
                        lexer.nextToken();
                        Map map2 = object;
                        return map2;
                    }
                    if (ch == '\'') {
                        if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbol(this.symbolTable, '\'');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if (ch == '\u001a') {
                            throw new JSONException("syntax error");
                        }
                        if (ch == ',') {
                            throw new JSONException("syntax error");
                        }
                        if (ch >= '0' && ch <= '9' || ch == '-') {
                            lexer.resetStringPosition();
                            lexer.scanNumber();
                            key = lexer.token() == 2 ? (Number)lexer.integerValue() : (Number)lexer.decimalValue(true);
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                            }
                        } else {
                            if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                throw new JSONException("syntax error");
                            }
                            key = lexer.scanSymbolUnQuoted(this.symbolTable);
                            lexer.skipWhitespace();
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                            }
                        }
                    }
                }
                lexer.incrementBufferPosition();
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                lexer.resetStringPosition();
                if (key == "@type") {
                    String typeName = lexer.scanSymbol(this.symbolTable, '\"');
                    Class<?> clazz = TypeUtils.loadClass(typeName);
                    ObjectDeserializer deserializer = this.config.getDeserializer(clazz);
                    lexer.nextToken(16);
                    this.resolveStatus = 2;
                    Object t = deserializer.deserialze(this, clazz, fieldName);
                    return t;
                }
                if (key == "$ref") {
                    lexer.nextToken(4);
                    if (lexer.token() == 4) {
                        Object rootContext;
                        String ref = lexer.stringVal();
                        lexer.nextToken(13);
                        Object refValue = null;
                        if ("@".equals(ref)) {
                            refValue = this.getContext().getObject();
                        } else if ("..".equals(ref)) {
                            ParseContext parentContext = context.getParentContext();
                            if (parentContext.getObject() != null) {
                                refValue = this.getContext().getObject();
                            } else {
                                this.getResolveTaskList().add(new ResolveTask(parentContext, ref));
                                this.setResolveStatus(1);
                            }
                        } else if ("$".equals(ref)) {
                            rootContext = context;
                            while (((ParseContext)rootContext).getParentContext() != null) {
                                rootContext = ((ParseContext)rootContext).getParentContext();
                            }
                            if (((ParseContext)rootContext).getObject() != null) {
                                refValue = ((ParseContext)rootContext).getObject();
                            } else {
                                this.getResolveTaskList().add(new ResolveTask((ParseContext)rootContext, ref));
                                this.setResolveStatus(1);
                            }
                        } else {
                            this.getResolveTaskList().add(new ResolveTask(context, ref));
                            this.setResolveStatus(1);
                        }
                        if (lexer.token() != 13) {
                            throw new JSONException("syntax error");
                        }
                        lexer.nextToken(16);
                        rootContext = refValue;
                        return rootContext;
                    }
                    throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                }
                if (ch == '\"') {
                    JSONScanner iso8601Lexer;
                    lexer.scanString();
                    String strValue = lexer.stringVal();
                    value = strValue;
                    if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(strValue)).scanISO8601DateIfMatch()) {
                        value = iso8601Lexer.getCalendar().getTime();
                    }
                    object.put(key, value);
                } else if (ch >= '0' && ch <= '9' || ch == '-') {
                    lexer.scanNumber();
                    value = lexer.token() == 2 ? lexer.integerValue() : lexer.decimalValue();
                    object.put(key, value);
                } else {
                    Map map3;
                    if (ch == '[') {
                        lexer.nextToken();
                        JSONArray list = new JSONArray();
                        this.parseArray(list);
                        value = list;
                        object.put(key, value);
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            map3 = object;
                            return map3;
                        }
                        if (lexer.token() == 16) continue;
                        throw new JSONException("syntax error");
                    }
                    if (ch == '{') {
                        lexer.nextToken();
                        Object obj = this.parseObject(new JSONObject());
                        object.put(key, obj);
                        this.setContext(context, obj, key);
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            this.setContext(context);
                            map3 = object;
                            return map3;
                        }
                        if (lexer.token() == 16) continue;
                        throw new JSONException("syntax error, " + lexer.tokenName());
                    }
                    lexer.nextToken();
                    value = this.parse();
                    object.put(key, value);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        map = object;
                        return map;
                    }
                    if (lexer.token() == 16) continue;
                    throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                }
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ',') break;
                lexer.incrementBufferPosition();
            }
            if (ch == '}') {
                lexer.incrementBufferPosition();
                lexer.resetStringPosition();
                lexer.nextToken();
                map = object;
                return map;
            }
            throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
        }
        finally {
            this.setContext(context);
        }
    }

    public ParseContext getContext() {
        return this.context;
    }

    public List<ResolveTask> getResolveTaskList() {
        return this.resolveTaskList;
    }

    public ResolveTask getLastResolveTask() {
        return this.resolveTaskList.get(this.resolveTaskList.size() - 1);
    }

    public void setContext(ParseContext context) {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = context;
    }

    public void popContext() {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = this.context.getParentContext();
    }

    public ParseContext setContext(Object object, Object fieldName) {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return null;
        }
        return this.setContext(this.context, object, fieldName);
    }

    public ParseContext setContext(ParseContext parent, Object object, Object fieldName) {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return null;
        }
        this.context = new ParseContext(parent, object, fieldName);
        this.addContext(this.context);
        return this.context;
    }

    private void addContext(ParseContext context) {
        int i;
        if ((i = this.contextArrayIndex++) >= this.contextArray.length) {
            int newLen = this.contextArray.length * 3 / 2;
            ParseContext[] newArray = new ParseContext[newLen];
            System.arraycopy(this.contextArray, 0, newArray, 0, this.contextArray.length);
            this.contextArray = newArray;
        }
        this.contextArray[i] = context;
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(ParserConfig config) {
        this.config = config;
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject((Type)clazz);
    }

    public <T> T parseObject(Type type) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        ObjectDeserializer derializer = this.config.getDeserializer(type);
        try {
            return derializer.deserialze(this, type, null);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList array = new ArrayList();
        this.parseArray(clazz, array);
        return array;
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    public void parseArray(Type type, Collection array) {
        this.parseArray(type, array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArray(Type type, Collection array, Object fieldName) {
        if (this.lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + JSONToken.name(this.lexer.token()));
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerDeserializer.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringDeserializer.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        this.setContext(array, fieldName);
        try {
            int i = 0;
            while (true) {
                Object val;
                if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (this.lexer.token() == 16) {
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.token() == 15) {
                    break;
                }
                if (Integer.TYPE == type) {
                    val = IntegerDeserializer.deserialze(this);
                    array.add(val);
                } else if (String.class == type) {
                    String value;
                    if (this.lexer.token() == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        Object obj = this.parse();
                        value = obj == null ? null : obj.toString();
                    }
                    array.add(value);
                } else {
                    val = deserializer.deserialze(this, type, i);
                    array.add(val);
                }
                if (this.lexer.token() == 16) {
                    this.lexer.nextToken(deserializer.getFastMatchToken());
                }
                ++i;
            }
        }
        finally {
            this.popContext();
        }
        this.lexer.nextToken(16);
    }

    public Object[] parseArray(Type[] types) {
        if (this.lexer.token() != 14) {
            throw new JSONException("syntax error");
        }
        Object[] list = new Object[types.length];
        if (types.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token() != 15) {
                throw new JSONException("syntax error");
            }
            this.lexer.nextToken(16);
            return new Object[0];
        }
        this.lexer.nextToken(2);
        for (int i = 0; i < types.length; ++i) {
            Object value;
            if (this.lexer.token() == 8) {
                value = null;
                this.lexer.nextToken(16);
            } else {
                Type type = types[i];
                if (type == Integer.TYPE || type == Integer.class) {
                    if (this.lexer.token() == 2) {
                        value = this.lexer.intValue();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else if (type == String.class) {
                    if (this.lexer.token() == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else {
                    boolean isArray = false;
                    Class<?> componentType = null;
                    if (i == types.length - 1 && type instanceof Class) {
                        Class clazz = (Class)type;
                        isArray = clazz.isArray();
                        componentType = clazz.getComponentType();
                    }
                    if (isArray && this.lexer.token() != 14) {
                        ArrayList varList = new ArrayList();
                        ObjectDeserializer derializer = this.config.getDeserializer(componentType);
                        int fastMatch = derializer.getFastMatchToken();
                        if (this.lexer.token() != 15) {
                            while (true) {
                                Object item = derializer.deserialze(this, type, null);
                                varList.add(item);
                                if (this.lexer.token() != 16) break;
                                this.lexer.nextToken(fastMatch);
                            }
                            if (this.lexer.token() != 15) {
                                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
                            }
                        }
                        value = TypeUtils.cast(varList, type, this.config);
                    } else {
                        ObjectDeserializer derializer = this.config.getDeserializer(type);
                        value = derializer.deserialze(this, type, null);
                    }
                }
            }
            list[i] = value;
            if (this.lexer.token() == 15) break;
            if (this.lexer.token() != 16) {
                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
            }
            if (i == types.length - 1) {
                this.lexer.nextToken(15);
                continue;
            }
            this.lexer.nextToken(2);
        }
        if (this.lexer.token() != 15) {
            throw new JSONException("syntax error");
        }
        this.lexer.nextToken(16);
        return list;
    }

    public void parseObject(Object object) {
        this.derializer.parseObject(this, object);
    }

    public Object parseArrayWithType(Type collectionType) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (actualTypes.length != 1) {
            throw new JSONException("not support type " + collectionType);
        }
        Type actualTypeArgument = actualTypes[0];
        if (actualTypeArgument instanceof Class) {
            ArrayList array = new ArrayList();
            this.parseArray((Class)actualTypeArgument, array);
            return array;
        }
        if (actualTypeArgument instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            Type upperBoundType = wildcardType.getUpperBounds()[0];
            if (Object.class.equals((Object)upperBoundType)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + collectionType);
            }
            ArrayList array = new ArrayList();
            this.parseArray((Class)upperBoundType, array);
            return array;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length != 1) {
                throw new JSONException("not support : " + typeVariable);
            }
            Type boundType = bounds[0];
            if (boundType instanceof Class) {
                ArrayList array = new ArrayList();
                this.parseArray((Class)boundType, array);
                return array;
            }
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
            ArrayList array = new ArrayList();
            this.parseArray(parameterizedType, array);
            return array;
        }
        throw new JSONException("TODO : " + collectionType);
    }

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
    }

    public static class ResolveTask {
        private final ParseContext context;
        private final String referenceValue;
        private FieldDeserializer fieldDeserializer;
        private ParseContext ownerContext;

        public ResolveTask(ParseContext context, String referenceValue) {
            this.context = context;
            this.referenceValue = referenceValue;
        }

        public ParseContext getContext() {
            return this.context;
        }

        public String getReferenceValue() {
            return this.referenceValue;
        }

        public FieldDeserializer getFieldDeserializer() {
            return this.fieldDeserializer;
        }

        public void setFieldDeserializer(FieldDeserializer fieldDeserializer) {
            this.fieldDeserializer = fieldDeserializer;
        }

        public ParseContext getOwnerContext() {
            return this.ownerContext;
        }

        public void setOwnerContext(ParseContext ownerContext) {
            this.ownerContext = ownerContext;
        }
    }
}

