/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.awt.Font;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontDeserializer
implements ObjectDeserializer {
    public static final FontDeserializer instance = new FontDeserializer();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error");
        }
        lexer.nextToken();
        int size = 0;
        int style = 0;
        String name = null;
        while (true) {
            if (lexer.token() == 13) break;
            if (lexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String key = lexer.stringVal();
            lexer.nextTokenWithColon(2);
            if (key.equalsIgnoreCase("name")) {
                if (lexer.token() != 4) throw new JSONException("syntax error");
                name = lexer.stringVal();
                lexer.nextToken();
            } else if (key.equalsIgnoreCase("style")) {
                if (lexer.token() != 2) throw new JSONException("syntax error");
                style = lexer.intValue();
                lexer.nextToken();
            } else {
                if (!key.equalsIgnoreCase("size")) throw new JSONException("syntax error, " + key);
                if (lexer.token() != 2) throw new JSONException("syntax error");
                size = lexer.intValue();
                lexer.nextToken();
            }
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        lexer.nextToken();
        return (T)new Font(name, style, size);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

