/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class ArraySerializer
implements ObjectSerializer {
    private final ObjectSerializer compObjectSerializer;

    public ArraySerializer(ObjectSerializer compObjectSerializer) {
        this.compObjectSerializer = compObjectSerializer;
    }

    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        Object[] array = (Object[])object;
        int size = array.length;
        int end = size - 1;
        if (end == -1) {
            out.append("[]");
            return;
        }
        out.append('[');
        for (int i = 0; i < end; ++i) {
            Object item = array[i];
            if (item == null) {
                out.append("null,");
                continue;
            }
            this.compObjectSerializer.write(serializer, item, null, null);
            out.append(',');
        }
        Object item = array[end];
        if (item == null) {
            out.append("null]");
        } else {
            this.compObjectSerializer.write(serializer, item, null, null);
            out.append(']');
        }
    }
}

